//
//  GSDocument.h
//  GSDocKit
//
//  Created by net263 on 2021/6/25.
//  Copyright © 2021 gensee. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

//文档类，封装了文档的数据，一份文档可以包含若干文档页
@interface GSDocument : NSObject
@property (assign, nonatomic)unsigned docID;//文档ID
@property (strong, nonatomic)NSMutableDictionary *pages;//保存所有文档页对象的数组
@property (assign, nonatomic)int currentPageIndex;//当前显示的文档页索引
@property (assign, nonatomic)BOOL savedOnServer;//布尔值表示该文档是否存放在服务器上， YES表示是
@property (copy, nonatomic)NSString *docName;//文档名称
@property (assign, nonatomic)long long ownerID;//文档所属的用户ID
@property (assign, nonatomic)int docType;
@property (assign, nonatomic)BOOL isPublish;//文档是否发布
@end

// 文档页类，封装了文档页数据
@interface GSDocPage : NSObject
@property (assign, nonatomic)unsigned pageID;//文档页ID
@property (strong, nonatomic)NSString *filePath;//文档页数据
@property (assign, nonatomic)short pageWidth;//文档页的宽
@property (assign, nonatomic)short pageHeight;//文档页的高
@property (strong, nonatomic)NSMutableArray *annosArray;//该文档页上的所有标注数据,替换上面的dic
@property (strong, nonatomic)NSString *aniCfg; //动画信息,路径

@property (assign, nonatomic) unsigned docID;//文档页ID
@end


NS_ASSUME_NONNULL_END
